﻿Imports System.Runtime.InteropServices
Imports System.Drawing
Imports System.Text
Imports System.Windows.Forms

Public Class API
    '*********** AVI *************
    <DllImport("avifil32.dll", EntryPoint:="AVIFileOpenA")> _
    Public Shared Function AVIFileOpen( _
        ByRef ppfile As Integer, _
        ByVal szFile As String, _
        ByVal mode As Integer, _
        ByVal pclsidHandler As Integer) As Integer
    End Function

    <DllImport("avifil32.dll", CharSet:=CharSet.Ansi, SetLastError:=True)> _
    Public Shared Function AVIFileRelease( _
        ByVal pfile As IntPtr) As Integer
    End Function

    <DllImport("avifil32.dll", CharSet:=CharSet.Ansi)> _
    Public Shared Sub AVIFileExit()
    End Sub

    <DllImport("avifil32.dll", CharSet:=CharSet.Ansi)> _
    Public Shared Sub AVIFileInit()
    End Sub

    <DllImport("avifil32.dll", EntryPoint:="AVIFileInfoA", _
        ExactSpelling:=True, CharSet:=CharSet.Ansi, SetLastError:=True)> _
    Public Shared Function AVIFileInfoRenamed( _
        ByVal pfile As IntPtr, _
        ByRef pfi As AVIFileInfo, _
        ByVal lSize As Integer) As Integer
    End Function

    Public Structure AVIFileInfo
        Public dwMaxBytesPerSecond As Int32
        Public dwFlags As Int32
        Public dwCaps As Int32
        Public dwStreams As Int32
        Public dwSuggestedBufferSize As Int32
        Public dwWidth As Int32
        Public dwHeight As Int32
        Public dwScale As Int32
        Public dwRate As Int32
        Public dwLength As Int32
        Public dwEditCount As Int32
        <MarshalAs(UnmanagedType.ByValTStr, SizeConst:=64)>
        Public szFileType As String
    End Structure

    '************ Menu ************
    <DllImport("user32.dll")> _
    Public Shared Function CreateMenu() As IntPtr
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function SetMenu( _
        ByVal hWnd As IntPtr, _
        ByVal hMenu As IntPtr) As Boolean
    End Function

    <DllImport("user32.dll", EntryPoint:="AppendMenuA")>
    Public Shared Function AppendMenu( _
        ByVal hMenu As IntPtr, _
        ByVal uFlags As UInteger, _
        ByVal uIDNewItem As Int32, _
        ByVal lpNewItem As String) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function DrawMenuBar( _
        ByVal hWnd As IntPtr) As Boolean
    End Function

    <DllImport("user32.dll", ExactSpelling:=True, CharSet:=CharSet.Ansi)> _
    Public Shared Function GetMenu( _
        ByVal hWnd As IntPtr) As IntPtr
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function GetSubMenu( _
        ByVal hMenu As IntPtr, _
        ByVal nPos As Integer) As IntPtr
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function GetMenuItemCount( _
        ByVal hMenu As IntPtr) As Integer
    End Function

    <DllImport("user32.dll", CallingConvention:=CallingConvention.Cdecl)> _
    Public Shared Function GetSystemMenu( _
        ByVal hWnd As IntPtr, _
        ByVal bRevert As Boolean) As IntPtr
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function GetMenuItemID( _
        ByVal hMenu As IntPtr, _
        ByVal nPosition As Integer) As IntPtr
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function CreatePopupMenu() As IntPtr
    End Function

    <DllImport("user32.dll", SetLastError:=True, CharSet:=CharSet.Auto)> _
    Public Shared Function InsertMenuItem( _
        ByVal hMenu As IntPtr, _
        ByVal uItem As Integer, _
        ByVal fByPosition As Boolean, _
        ByRef lpmii As MenuItemInfo) As Boolean
    End Function

    <StructLayout(LayoutKind.Sequential)> _
    Public Structure MenuItemInfo
        Public cbSize As UInteger
        Public fMask As UInteger
        Public fType As UInteger
        Public fState As UInteger
        Public wID As UInteger
        Public hSubMenu As IntPtr
        Public hbmpChecked As IntPtr
        Public hbmpUnchecked As IntPtr
        Public dwItemData As IntPtr
        Public dwTypeData As String
        Public cch As UInteger
        Public hbmpItem As IntPtr
        Public Shared Property SizeOf As UInteger
            Get
                Return Marshal.SizeOf(TypeOf(MenuItemInfo))
            End Get
            Set(value As UInteger)
            End Set
        End Property
    End Structure

    <DllImport("user32.dll", EntryPoint:="GetMenuItemInfoA")> _
    Public Shared Function GetMenuItemInfo( _
    ByVal hMenu As IntPtr, _
    ByVal uItem As Integer, _
    ByVal fByPosition As Boolean, _
    ByRef lpmii As MenuItemInfo) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function DestroyMenu( _
    ByVal hWnd As IntPtr) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function EndMenu() As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function GetMenuItemRect( _
    ByVal hWnd As IntPtr, _
    ByVal hMenu As IntPtr, _
    ByVal uItem As UInteger, _
    ByRef lprcItem As Rectangle) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function ModifyMenu( _
    ByVal hMenu As IntPtr, _
    ByVal uID As IntPtr, _
    ByVal wFlags As Integer, _
    ByVal wIDNewItem As IntPtr, _
    ByVal lpNewItem As String) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function RemoveMenu( _
    ByVal hMenu As IntPtr, _
    ByVal nPosition As Integer, _
    ByVal wFlags As Integer) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function SetMenuItemBitmaps( _
    ByVal hMenu As IntPtr, _
    ByVal nPosition As Integer, _
    ByVal wFlags As Integer, _
    ByVal hBitmapUnchecked As IntPtr, _
    ByVal hBitmapChecked As IntPtr) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function SetMenuItemInfo( _
    ByVal hMenu As IntPtr, _
    ByVal nPositin As Integer, _
    ByVal wFlags As Integer, _
    ByRef lpmii As MenuItemInfo) As Boolean
    End Function

    <DllImport("User32.Dll")> _
    Public Shared Function TrackPopupMenuEx( _
    ByVal hMenu As IntPtr, _
    ByVal uFlags As Long, _
    ByVal x As Integer, _
    ByVal y As Integer, _
    ByVal hWnd As IntPtr, _
    ByVal lptpm As IntPtr) As Integer
    End Function

    '************** Window ************

    <DllImport("user32.dll")> _
    Public Shared Function FindWindow( _
     ByVal lpClassName As String, _
     ByVal lpWindowName As String) As IntPtr
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function GetActiveWindow() As IntPtr
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function GetForegroundWindow() As IntPtr
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function GetDesktopWindow() As IntPtr
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function WindowFromPoint( _
        ByVal xPoint As Integer, _
        ByVal yPoint As Integer) As IntPtr
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function GetParent( _
        ByVal hWnd As IntPtr) As IntPtr
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function FlashWindow( _
        ByVal hWnd As IntPtr, _
        ByVal bInvert As Boolean) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function GetClassName( _
        ByVal hWnd As System.IntPtr, _
        ByVal lpClassName As StringBuilder, _
        ByVal nMaxCount As Integer) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function GetClientRect( _
        ByVal hWnd As IntPtr, _
        ByRef lpRect As Rectangle) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function GetWindowRect( _
        ByVal hWnd As IntPtr, _
        ByRef lpRect As Rectangle) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function GetWindowText( _
        ByVal hWnd As IntPtr, _
        ByVal lpString As StringBuilder, _
        ByVal nMaxCount As Integer) As Integer
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function GetWindowTextLength( _
        ByVal hwnd As IntPtr) As Integer
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function IsChild( _
        ByVal hWndParent As IntPtr, _
        ByVal hWnd As IntPtr) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function IsIconic( _
    ByVal hWnd As IntPtr) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function IsWindow( _
        ByVal hWnd As IntPtr) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function IsWindowEnabled( _
        ByVal hWnd As IntPtr) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function IsWindowUnicode( _
        ByVal hWnd As IntPtr) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function IsWindowVisible( _
        ByVal hWnd As IntPtr) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function IsZoomed( _
        ByVal hWnd As IntPtr) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function SetActiveWindow( _
        ByVal hWnd As IntPtr) As IntPtr
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function SetForegroundWindow( _
        ByVal hWnd As IntPtr) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function EnableWindow( _
        ByVal hWnd As IntPtr, _
        ByVal bEnable As Boolean) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function SetParent( _
        ByVal hWndChild As IntPtr, _
        ByVal hWndNewParent As IntPtr) As IntPtr
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function SetWindowText( _
        ByVal hWnd As IntPtr, _
        ByVal lpString As String) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function DestroyWindow( _
        hWnd As IntPtr) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function OpenIcon( _
        hWnd As IntPtr) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function CloseWindow( _
        hWnd As IntPtr) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function BringWindowToTop( _
        hWnd As IntPtr) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function MoveWindow( _
        ByVal hWnd As IntPtr, _
        ByVal x As Integer, _
        ByVal y As Integer, _
        ByVal nWidth As Integer, _
        ByVal nHeight As Integer, _
        ByVal bRepaint As Boolean) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function ShowWindow( _
        ByVal hWnd As IntPtr, _
        ByVal nCmdShow As ShowWindowCommands) As Boolean
    End Function

    Public Enum ShowWindowCommands As Integer
        ''' <summary>
        ''' Hides the window and activates another window.
        ''' </summary>
        Hide = 0
        ''' <summary>
        ''' Activates and displays a window. If the window is minimized or
        ''' maximized, the system restores it to its original size and position.
        ''' An application should specify this flag when displaying the window
        ''' for the first time.
        ''' </summary>
        Normal = 1
        ''' <summary>
        ''' Activates the window and displays it as a minimized window.
        ''' </summary>
        ShowMinimized = 2
        ''' <summary>
        ''' Maximizes the specified window.
        ''' </summary>
        Maximize = 3
        ' is this the right value?
        ''' <summary>
        ''' Activates the window and displays it as a maximized window.
        ''' </summary>      
        ShowMaximized = 3
        ''' <summary>
        ''' Displays a window in its most recent size and position. This value
        ''' is similar to <see cref="Win32.ShowWindowCommand.Normal"/>, except
        ''' the window is not actived.
        ''' </summary>
        ShowNoActivate = 4
        ''' <summary>
        ''' Activates the window and displays it in its current size and position.
        ''' </summary>
        Show = 5
        ''' <summary>
        ''' Minimizes the specified window and activates the next top-level
        ''' window in the Z order.
        ''' </summary>
        Minimize = 6
        ''' <summary>
        ''' Displays the window as a minimized window. This value is similar to
        ''' <see cref="Win32.ShowWindowCommand.ShowMinimized"/>, except the
        ''' window is not activated.
        ''' </summary>
        ShowMinNoActive = 7
        ''' <summary>
        ''' Displays the window in its current size and position. This value is
        ''' similar to <see cref="Win32.ShowWindowCommand.Show"/>, except the
        ''' window is not activated.
        ''' </summary>
        ShowNA = 8
        ''' <summary>
        ''' Activates and displays the window. If the window is minimized or
        ''' maximized, the system restores it to its original size and position.
        ''' An application should specify this flag when restoring a minimized window.
        ''' </summary>
        Restore = 9
        ''' <summary>
        ''' Sets the show state based on the SW_* value specified in the
        ''' STARTUPINFO structure passed to the CreateProcess function by the
        ''' program that started the application.
        ''' </summary>
        ShowDefault = 10
        ''' <summary>
        '''  <b>Windows 2000/XP:</b> Minimizes a window, even if the thread
        ''' that owns the window is not responding. This flag should only be
        ''' used when minimizing windows from a different thread.
        ''' </summary>
        ForceMinimize = 11
    End Enum

    <DllImport("user32.dll")> _
    Public Shared Function AnimateWindow( _
        ByVal hwnd As IntPtr, _
        ByVal dwTime As Integer, _
        ByVal dwFlags As AnimateWindowFlags) As Boolean
    End Function

    <Flags()> _
    Public Enum AnimateWindowFlags
        AW_HOR_POSITIVE = &H1
        AW_HOR_NEGATIVE = &H2
        AW_VER_POSITIVE = &H4
        AW_VER_NEGATIVE = &H8
        AW_CENTER = &H10
        AW_HIDE = &H10000
        AW_ACTIVATE = &H20000
        AW_SLIDE = &H40000
        AW_BLEND = &H80000
    End Enum

    <DllImport("user32.dll")> _
    Public Shared Function SetWindowPos( _
        ByVal hWnd As IntPtr, _
        ByVal hWndInsertAfter As SetWindowPosInsertAfterFlags, _
        ByVal x As Integer, _
        ByVal y As Integer, _
        ByVal cx As Integer, _
        ByVal cy As Integer, _
        ByVal uFlags As SetWindowPosFlags) As Boolean
    End Function

    <Flags()> _
    Public Enum SetWindowPosFlags As UInteger
        ''' <summary>If the calling thread and the thread that owns the window are attached to different input queues,
        ''' the system posts the request to the thread that owns the window. This prevents the calling thread from
        ''' blocking its execution while other threads process the request.</summary>
        ''' <remarks>SWP_ASYNCWINDOWPOS</remarks>
        SynchronousWindowPosition = &H4000
        ''' <summary>Prevents generation of the WM_SYNCPAINT message.</summary>
        ''' <remarks>SWP_DEFERERASE</remarks>
        DeferErase = &H2000
        ''' <summary>Draws a frame (defined in the window's class description) around the window.</summary>
        ''' <remarks>SWP_DRAWFRAME</remarks>
        DrawFrame = &H20
        ''' <summary>Applies new frame styles set using the SetWindowLong function. Sends a WM_NCCALCSIZE message to
        ''' the window, even if the window's size is not being changed. If this flag is not specified, WM_NCCALCSIZE
        ''' is sent only when the window's size is being changed.</summary>
        ''' <remarks>SWP_FRAMECHANGED</remarks>
        FrameChanged = &H20
        ''' <summary>Hides the window.</summary>
        ''' <remarks>SWP_HIDEWINDOW</remarks>
        HideWindow = &H80
        ''' <summary>Does not activate the window. If this flag is not set, the window is activated and moved to the
        ''' top of either the topmost or non-topmost group (depending on the setting of the hWndInsertAfter
        ''' parameter).</summary>
        ''' <remarks>SWP_NOACTIVATE</remarks>
        DoNotActivate = &H10
        ''' <summary>Discards the entire contents of the client area. If this flag is not specified, the valid
        ''' contents of the client area are saved and copied back into the client area after the window is sized or
        ''' repositioned.</summary>
        ''' <remarks>SWP_NOCOPYBITS</remarks>
        DoNotCopyBits = &H100
        ''' <summary>Retains the current position (ignores X and Y parameters).</summary>
        ''' <remarks>SWP_NOMOVE</remarks>
        IgnoreMove = &H2
        ''' <summary>Does not change the owner window's position in the Z order.</summary>
        ''' <remarks>SWP_NOOWNERZORDER</remarks>
        DoNotChangeOwnerZOrder = &H200
        ''' <summary>Does not redraw changes. If this flag is set, no repainting of any kind occurs. This applies to
        ''' the client area, the nonclient area (including the title bar and scroll bars), and any part of the parent
        ''' window uncovered as a result of the window being moved. When this flag is set, the application must
        ''' explicitly invalidate or redraw any parts of the window and parent window that need redrawing.</summary>
        ''' <remarks>SWP_NOREDRAW</remarks>
        DoNotRedraw = &H8
        ''' <summary>Same as the SWP_NOOWNERZORDER flag.</summary>
        ''' <remarks>SWP_NOREPOSITION</remarks>
        DoNotReposition = &H200
        ''' <summary>Prevents the window from receiving the WM_WINDOWPOSCHANGING message.</summary>
        ''' <remarks>SWP_NOSENDCHANGING</remarks>
        DoNotSendChangingEvent = &H400
        ''' <summary>Retains the current size (ignores the cx and cy parameters).</summary>
        ''' <remarks>SWP_NOSIZE</remarks>
        IgnoreResize = &H1
        ''' <summary>Retains the current Z order (ignores the hWndInsertAfter parameter).</summary>
        ''' <remarks>SWP_NOZORDER</remarks>
        IgnoreZOrder = &H4
        ''' <summary>Displays the window.</summary>
        ''' <remarks>SWP_SHOWWINDOW</remarks>
        ShowWindow = &H40
    End Enum

    Public Enum SetWindowPosInsertAfterFlags As Integer
        HWND_TOP = 0
        HWND_BOTTOM = 1
        HWND_TOPMOST = -1
        HWND_NOTOPMOST = -2
    End Enum

    <DllImport("user32.dll")> _
    Public Shared Function FlashWindowEx( _
        ByRef pwfi As FlashWInfo) As Boolean
    End Function

    <StructLayout(LayoutKind.Sequential)>
    Public Structure FlashWInfo
        Public cbSize As UInt32
        Public hwnd As IntPtr
        Public dwFlags As FlashWInfoFlags
        Public uCount As UInt32
        Public dwTimeout As UInt32

        Public Shared Property SizeOf As UInt32
            Get
            Return Marshal.SizeOf(TypeOf(FlashWInfo)
            End Get
            Set(value As UInt32)

            End Set
        End Property
    End Structure

    Public Enum FlashWInfoFlags As UInteger
        FlashW_Stop = &H0
        FlashW_Caption = &H1
        FlashW_Tray = &H2
        FlashW_All = &H3
        FlashW_Timer = &H4
        FlashW_TimerOfg = &H12
    End Enum

    <DllImport("user32.dll")> _
    Public Shared Function FindWindowEx( _
        ByVal parentHwnd As IntPtr, _
        ByVal childAfterHwnd As IntPtr, _
        ByVal className As String, _
        ByVal windowTitle As String) As IntPtr
    End Function

    '************ Mouse & Keyboard ***********

    <DllImport("user32.dll")> _
    Public Shared Function ClipCursor( _
        ByRef lpRect As Rectangle) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function GetClipCursor( _
        ByRef lpRect As Rectangle) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function ClientToScreen( _
        ByVal hWnd As IntPtr, _
        ByRef lpPoint As Point) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function GetCursor() As IntPtr
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function GetCursorPos( _
        ByRef lpPoint As Point) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function SetCursorPos( _
        ByVal x As Integer, _
        ByVal y As Integer) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function LoadCursor( _
        ByVal hInstance As IntPtr, _
        ByVal lpCursorName As String) As IntPtr
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function LoadCursorFromFile( _
        ByVal lpFileName As String) As IntPtr
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function SetSystemCursor( _
        ByVal hCur As IntPtr, _
        ByVal id As Integer) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function ShowCursor( _
        ByVal bShow As Boolean) As Integer
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function GetDoubleClickTime() As Integer
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function SetDoubleClickTime( _
        ByVal uInterval As UInteger) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function SwapMouseButton( _
        ByVal fSwap As Boolean) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function SetCapture( _
        ByVal hWnd As IntPtr) As IntPtr
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function ReleaseCapture() As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Sub mouse_event( _
        ByVal dwFlags As MouseEventFlags, _
        ByVal dx As Integer, _
        ByVal dy As Integer, _
        ByVal dwData As Integer, _
        ByVal dwExtraInfo As Integer)
    End Sub

    <Flags()>
    Public Enum MouseEventFlags As UInteger
        LeftDown = &H2
        LeftUp = &H4
        MiddleDown = &H20
        MiddleUp = &H40
        Move = &H1
        Absolute = &H8000
        RightDown = &H8
        RightUp = &H10
        Wheel = &H800
        XDown = &H80
        XUp = &H100
    End Enum

    <DllImport("user32.dll")> _
    Public Shared Function BlockInput( _
        ByVal fBlockIt As Boolean) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function ActivateKeyboardLayout( _
        ByVal hkl As HKL, _
        ByVal uFlags As UInteger) As Integer
    End Function

    Public Enum HKL
        HKL_Prev = 0
        HKL_Next = 1
    End Enum

    <DllImport("user32.dll")> _
    Public Shared Function GetKeyboardLayoutName( _
        ByVal pwszKLID As StringBuilder) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function LoadKeyboardLayout( _
        ByVal pwszKLID As String, _
        ByVal uFlags As UInteger) As Boolean
    End Function

    <DllImport("kernel32.dll")> _
    Public Shared Function VerLanguageName( _
        ByVal wLang As UInteger, _
        ByRef szLang As StringBuilder, _
        ByVal wSize As Integer) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function CreateCaret( _
        ByVal hWnd As IntPtr, _
        ByVal hBitmap As IntPtr, _
        ByVal nWidth As Integer, _
        ByVal nHeight As Integer) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function ShowCaret( _
        ByVal hWnd As IntPtr) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function HideCaret( _
        ByVal hWnd As IntPtr) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function GetCaretBlinkTime() As UInteger
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function SetCaretBlinkTime( _
        ByVal uMSeconds As UInteger) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function GetKeyboardState( _
        ByVal lpKeyState() As Byte) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function SetKeyboardState( _
        ByVal lpKeyState() As Byte) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function GetKeyboardType( _
        ByVal nTypeFlag As Integer) As Integer
    End Function

    Public Enum VirtualKeyStates
        LBUTTON = 1
        RBUTTON = 2
        CANCEL_KEY = 3
        MBUTTON = 4
        XBUTTON1 = 5
        XBUTTON2 = 6
        KEY_BACK = 8
        TAB_KEY = 9
        CLEAR = 12
        RETURN_KEY = 13
        SHIFT = 16
        CONTROL = 17
        MENU = 18
        PAUSE = 19
        CAPITAL = 20
        KANA = 21
        HANGUL = 21
        JUNJA = 23
        FINAL = 24
        HANJA = 25
        KANJI = 25
        ESCAPE = 27
        CONVERT = 28
        NONCONVERT = 29
        ACCEPT = 30
        MODECHANGE = 31
        SPACE_KEY = 32
        PRIOR = 33
        NEXT_KEY = 34
        END_KEY = 35
        HOME = 36
        LEFT_KEY = 37
        UP = 38
        RIGHT_KEY = 39
        DOWN = 40
        SELECT_KEY = 41
        PRINT_KEY = 42
        EXECUTE = 43
        SNAPSHOT = 44
        INSERT = 45
        DELETE = 46
        HELP = 47
        KEY_0 = 48
        KEY_1 = 49
        KEY_2 = 50
        KEY_3 = 51
        KEY_4 = 52
        KEY_5 = 53
        KEY_6 = 54
        KEY_7 = 55
        KEY_8 = 56
        KEY_9 = 57
        KEY_A = 65
        KEY_B = 66
        KEY_C = 67
        KEY_D = 68
        KEY_E = 69
        KEY_F = 70
        KEY_G = 71
        KEY_H = 72
        KEY_I = 73
        KEY_J = 74
        KEY_K = 75
        KEY_L = 76
        KEY_M = 77
        KEY_N = 78
        KEY_O = 79
        KEY_P = 80
        KEY_Q = 81
        KEY_R = 82
        KEY_S = 83
        KEY_T = 84
        KEY_U = 85
        KEY_V = 86
        KEY_W = 87
        KEY_X = 88
        KEY_Y = 89
        KEY_Z = 90
        LWIN = 91
        RWIN = 92
        APPS = 93
        SLEEP = 95
        NUMPAD0 = 96
        NUMPAD1 = 97
        NUMPAD2 = 98
        NUMPAD3 = 99
        NUMPAD4 = 100
        NUMPAD5 = 101
        NUMPAD6 = 102
        NUMPAD7 = 103
        NUMPAD8 = 104
        NUMPAD9 = 105
        MULTIPLY = 106
        ADD = 107
        SEPARATOR = 108
        SUBTRACT = 109
        DECIMAL_KEY = 110
        DIVIDE = 111
        F1 = 112
        F2 = 113
        F3 = 114
        F4 = 115
        F5 = 116
        F6 = 117
        F7 = 118
        F8 = 119
        F9 = 120
        F10 = 121
        F11 = 122
        F12 = 123
        F13 = 124
        F14 = 125
        F15 = 126
        F16 = 127
        F17 = 128
        F18 = 129
        F19 = 130
        F20 = 131
        F21 = 132
        F22 = 133
        F23 = 134
        F24 = 135
        NUMLOCK = 144
        SCROLL = 145
        LSHIFT = 160
        RSHIFT = 161
        LCONTROL = 162
        RCONTROL = 163
        LMENU = 164
        RMENU = 165
        BROWSER_BACK = 166
        BROWSER_FORWARD = 167
        BROWSER_REFRESH = 168
        BROWSER_STOP = 169
        BROWSER_SEARCH = 170
        BROWSER_FAVORITES = 171
        BROWSER_HOME = 172
        VOLUME_MUTE = 173
        VOLUME_DOWN = 174
        VOLUME_UP = 175
        MEDIA_NEXT_TRACK = 176
        MEDIA_PREV_TRACK = 177
        MEDIA_STOP = 178
        MEDIA_PLAY_PAUSE = 179
        LAUNCH_MAIL = 180
        LAUNCH_MEDIA_SELECT = 181
        LAUNCH_APP1 = 182
        LAUNCH_APP2 = 183
        OEM_1 = 186
        OEM_PLUS = 187
        OEM_COMMA = 188
        OEM_MINUS = 189
        OEM_PERIOD = 190
        OEM_2 = 191
        OEM_3 = 192
        OEM_4 = 219
        OEM_5 = 220
        OEM_6 = 221
        OEM_7 = 222
        OEM_8 = 223
        OEM_102 = 226
        PROCESSKEY = 229
        PACKET = 231
        ATTN = 246
        CRSEL = 247
        EXSEL = 248
        EREOF = 249
        PLAY = 250
        ZOOM = 251
        NONAME = 252
        PA1 = 253
        OEM_CLEAR = 254
    End Enum

    <DllImport("user32.dll")> _
    Public Shared Function GetKeyState( _
        ByVal nVirtKey As VirtualKeyStates) As Short
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function GetAsyncKeyState( _
        ByVal vKey As Keys) As Short
    End Function

    <DllImport("user32.dll")> _
    Public Shared Sub keybd_event( _
        ByVal bVk As Keys, _
        ByVal bScan As Byte, _
        ByVal dwFlags As UInteger, _
        ByVal dwExtraInfo As UIntPtr)
    End Sub

    <DllImport("user32.dll")> _
    Public Shared Function SendInput( _
        ByVal nInputs As Integer, _
        ByRef pInputs() As Input, _
        ByVal cbSize As Integer) As Integer
    End Function

    Public Structure Input
        Public Type As UInt32
        Public Data As MouseKeyboardHardwareInput
        Public Property SizeOf As Integer
            Get
                Return Marshal.SizeOf(TypeOf(Input))
            End Get
            Set(value As Integer)
            End Set
        End Property
    End Structure

    <StructLayout(LayoutKind.Explicit)>
    Public Structure MouseKeyboardHardwareInput
        <FieldOffset(0)>
        Public Mouse As MouseInput
        <FieldOffset(0)>
        Public Keyboard As KeyboardInput
        <FieldOffset(0)>
        Public Hardware As HardwareInput
    End Structure

    Public Structure MouseInput
        Public X As Integer
        Public Y As Integer
        Public MouseData As UInt32
        Public Flags As UInt32
        Public Time As UInt32
        Public ExtraInfo As IntPtr
    End Structure

    Public Structure KeyboardInput
        Public KeyCode As UInt16
        Public Scan As UInt16
        Public Flags As UInt32
        Public Time As UInt32
        Public ExtraInfo As IntPtr
    End Structure

    Public Structure HardwareInput
        Public Msg As UInt32
        Public ParamL As UInt16
        Public ParamH As UInt16
    End Structure

    Public Enum ModifierFlages
        Alt = &H1
        Control = &H2
        Shift = &H4
        Windows = &H8
        Left = &H8000
        Right = &H4000
    End Enum

    <DllImport("user32.dll")> _
    Public Shared Function RegisterHotKey( _
        ByVal hWnd As IntPtr, _
        ByVal id As Integer, _
        ByVal fsModifiers As ModifierFlages, _
        ByVal vk As Keys) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function UnregisterHotKey( _
        ByVal hWnd As IntPtr, _
        ByVal id As Integer) As Integer
    End Function

    '******** Graphics *********
    <DllImport("user32.dll")> _
    Public Shared Function GetDC( _
        ByVal hWnd As IntPtr) As IntPtr
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function GetWindowDC( _
        ByVal hWnd As IntPtr) As IntPtr
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function WindowFromDC( _
        ByVal hDC As IntPtr) As IntPtr
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function DeleteDC( _
        ByVal hDC As IntPtr) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function ReleaseDC( _
        ByVal hWnd As IntPtr, _
        ByVal hDC As IntPtr) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function MoveToEx( _
        ByVal hDC As IntPtr, _
        ByVal x As Integer, _
        ByVal y As Integer, _
        lpPoint As IntPtr) As Long
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function CreatePen( _
        ByVal penStyle As PenStyle, _
        ByVal nWidth As Integer, _
        ByVal penColor As UInteger) As IntPtr
    End Function

    Public Enum PenStyle As Integer
        PS_SOLID = 0
        'The pen is solid.
        PS_DASH = 1
        'The pen is dashed.
        PS_DOT = 2
        'The pen is dotted.
        PS_DASHDOT = 3
        'The pen has alternating dashes and dots.
        PS_DASHDOTDOT = 4
        'The pen has alternating dashes and double dots.
        PS_NULL = 5
        'The pen is invisible.
        PS_INSIDEFRAME = 6
        ' Normally when the edge is drawn, it’s centred on the outer edge meaning that half the width of the pen is drawn
        ' outside the shape’s edge, half is inside the shape’s edge. When PS_INSIDEFRAME is specified the edge is drawn
        'completely inside the outer edge of the shape.
        PS_USERSTYLE = 7
        PS_ALTERNATE = 8
        PS_STYLE_MASK = &HF

        PS_ENDCAP_ROUND = &H0
        PS_ENDCAP_SQUARE = &H100
        PS_ENDCAP_FLAT = &H200
        PS_ENDCAP_MASK = &HF00

        PS_JOIN_ROUND = &H0
        PS_JOIN_BEVEL = &H1000
        PS_JOIN_MITER = &H2000
        PS_JOIN_MASK = &HF000

        PS_COSMETIC = &H0
        PS_GEOMETRIC = &H10000
        PS_TYPE_MASK = &HF0000
    End Enum

    <DllImport("Gdi32.dll")> _
    Public Shared Function SelectObject( _
        ByVal hDC As IntPtr, _
        ByVal hObject As IntPtr) As IntPtr
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function DeleteObject( _
        ByVal hObject As IntPtr) As Boolean
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function LineTo( _
        ByVal hDC As IntPtr, _
        ByVal nXEnd As Integer, _
        ByVal nYEnd As Integer) As Boolean
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function Arc( _
        ByVal hDC As IntPtr, _
        ByVal nLeftRect As Integer, _
        ByVal nTopRect As Integer, _
        ByVal nRightRect As Integer, _
        ByVal nBottomRect As Integer, _
        ByVal nXStartArc As Integer, _
        ByVal nYStartArc As Integer, _
        ByVal nXEndArc As Integer, _
        ByVal nYEndArc As Integer) As Boolean
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function AngleArc( _
        ByVal hDC As Long, _
        ByVal x As Integer, _
        ByVal y As Integer, _
        ByVal dwRadius As UInteger, _
        ByVal eStartAngle As Single, _
        ByVal eSweepAngle As Single) As Boolean
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function ArcTo( _
        ByVal hDC As IntPtr, _
        ByVal nLeftRect As Integer, _
        ByVal nTopRect As Integer, _
        ByVal nRightRect As Integer, _
        ByVal nBottomRect As Integer, _
        ByVal nXStartArc As Integer, _
        ByVal nYStartArc As Integer, _
        ByVal nXEndArc As Integer, _
        ByVal nYEndArc As Integer) As Boolean
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function Ellipse( _
        ByVal hDC As IntPtr, _
        ByVal nLeftRect As Integer, _
        ByVal nTopRect As Integer, _
        ByVal nRightRect As Integer, _
        ByVal nBottomRect As Integer) As Boolean
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function PolyBezierTo( _
        ByVal hDC As IntPtr, _
        ByVal lpPoints() As Point, _
        ByVal pointsCount As Integer) As Boolean
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function PolyBezier( _
        ByVal hDC As IntPtr, _
        ByVal lpPoints() As Point, _
        ByVal pointsCount As Integer) As Boolean
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function Polygon( _
        ByVal hDC As IntPtr, _
        ByVal lpPoints() As Point, _
        ByVal pointsCount As Integer) As Boolean
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function Polyline( _
        ByVal hDC As IntPtr, _
        ByVal lpPoints() As Point, _
        ByVal pointsCount As Integer) As Boolean
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function PolylineTo( _
        ByVal hDC As IntPtr, _
        ByVal lpPoints() As Point, _
        ByVal pointsCount As Integer) As Boolean
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function PolyPolyline( _
        ByVal hDC As IntPtr, _
        ByVal lpPoints() As Point, _
        ByVal lpdwPolyPoints() As Integer, _
        ByVal ppCount As Integer) As Boolean
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function Pie( _
        ByVal hDC As IntPtr, _
        ByVal nLeftRect As Integer, _
        ByVal nTopRect As Integer, _
        ByVal nRightRect As Integer, _
        ByVal nBottomRect As Integer, _
        ByVal nXRadial1 As Integer, _
        ByVal nYRadial1 As Integer, _
        ByVal nXRadial2 As Integer, _
        ByVal nYRadial2 As Integer) As Boolean
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function PolyPolygon( _
        ByVal hDC As IntPtr, _
        ByVal lpPoints() As Point, _
        ByVal lpdwPolyPoints() As Integer, _
        ByVal ppCount As Integer) As Boolean
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function Rectangle( _
        ByVal hDC As IntPtr, _
        ByVal nLeftRect As Integer, _
        ByVal nTopRect As Integer, _
        ByVal nRightRect As Integer, _
        ByVal nBottomRect As Integer) As Boolean
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function RoundRect( _
        ByVal hDC As IntPtr, _
        ByVal nLeftRect As Integer, _
        ByVal nTopRect As Integer, _
        ByVal nRightRect As Integer, _
        ByVal nBottomRect As Integer, _
        ByVal nWidth As Integer, _
        ByVal nHeight As Integer) As Boolean
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function CreateSolidBrush( _
        ByVal crColor As Integer) As IntPtr
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function CreateHatchBrush( _
        ByVal nIndex As CreateHatchBrushType, _
        ByVal crColor As Integer) As IntPtr
    End Function

    Public Enum CreateHatchBrushType
        HS_BDiagonal = &H3
        HS_Cross = &H4
        HS_DiagonalCross = &H5
        HS_FDiagonal = &H2
        HS_Horizontal = &H0
        HS_Vertical = &H1
    End Enum

    <DllImport("user32.dll")> _
    Public Shared Function FillRect( _
        ByVal hDC As IntPtr,
        ByRef lpRect As Rectangle,
        hBrush As IntPtr) As Boolean
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function CreateEllipticRgn( _
        ByVal hDC As IntPtr, _
        ByVal nLeftRect As Integer, _
        ByVal nTopRect As Integer, _
        ByVal nRightRect As Integer, _
        ByVal nBottomRect As Integer) As IntPtr
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function CreateEllipticRgnIndirect( _
        ByRef lpRect As Rectangle) As IntPtr
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function CreateRectRgn( _
        ByVal nLeftRect As Integer, _
        ByVal nTopRect As Integer, _
        ByVal nRightRect As Integer, _
        ByVal nBottomRect As Integer) As IntPtr
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function CreateRectRgnIndirect( _
        ByRef lpRect As Rectangle) As IntPtr
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function CreateRoundRectRgn( _
        ByVal nLeftRect As Integer, _
        ByVal nTopRect As Integer, _
        ByVal nRightRect As Integer, _
        ByVal nBottomRect As Integer, _
        ByVal nWidth As Integer, _
        ByVal nHeight As Integer) As IntPtr
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function CreatePolygonRgn( _
        ByVal lpPoints() As Point, _
        ByVal pointsCount As Integer, _
        ByVal fnPolyFillMode As Integer) As IntPtr
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function CreatePolyPolygonRgn( _
        ByVal lpPoints() As Point, _
        ByVal lpdwPolyPoints() As Integer, _
        ByVal ppCount As Integer, _
        ByVal fnPolyFillMode As Integer) As IntPtr
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function FillRgn( _
        ByVal hDC As IntPtr, _
        ByVal hRgn As IntPtr, _
        ByVal hBrush As IntPtr) As IntPtr
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function FloodFill( _
        ByVal hDC As IntPtr, _
        ByVal nXStart As Integer, _
        ByVal nYStart As Integer, _
        ByVal colorFill As Integer) As Integer
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function DrawFrameControl( _
        ByVal hDC As IntPtr, _
        ByRef lpRect As Rectangle, _
        ByVal uType As DrawFrameControlTypes, _
        ByVal uState As DrawFrameControlStates) As Boolean
    End Function

    <Flags()>
    Public Enum DrawFrameControlTypes
        DFC_Button = &H4
        DFC_Caption = &H1
        DFC_Menu = &H2
        DFC_PopupMenu = &H5
        DFC_Scroll = &H3
    End Enum

    <Flags()>
    Public Enum DrawFrameControlStates
        Button_Check = 0
        Button_RadioImage = 1
        Button_RadioMask = 2
        Button_Radio = 4
        Button_State = 8
        Button_Push = &H10
        Caption_Close = 0
        Caption_Minimize = 1
        Caption_Maximize = 2
        Caption_Restore = 3
        Caption_Help = 4
        Menu_Arrow = 0
        Menu_Check = 1
        Menu_Bullet = 2
        Menu_ArrowRight = 4
        Scroll_Up = 0
        Scroll_Down = 1
        Scroll_Left = 2
        Scroll_Right = 3
        Scroll_ComboBox = 5
        Scroll_SizeGrip = 8
        Scroll_SizeGripRight = &H10
        Rectangle_AdjastRectangle = &H2000
        State_Inactive = &H100
        State_Pushed = &H200
        State_Checked = &H400
        State_Transparent = &H800
        State_Hot = &H1000
        State_Flat = &H4000
        State_Mono = &H8000
    End Enum

    <DllImport("user32.dll")> _
    Public Shared Function DrawEdge( _
        ByVal hDC As IntPtr, _
        ByVal qRect As Rectangle, _
        ByVal edge As Integer, _
        ByVal grfFlags As Integer) As Boolean
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function InvertRgn( _
        ByVal hDC As IntPtr, _
        ByVal hRgn As IntPtr) As Boolean
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function OffsetRgn( _
        ByVal hRgn As IntPtr, _
        ByVal nXOffset As Integer, _
        ByVal nYOffset As Integer) As Integer
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function CombineRgn( _
        ByVal hRgnDest As IntPtr, _
        ByVal hRgnSrc1 As IntPtr, _
        ByVal hRgnSrc2 As IntPtr, _
        ByVal fnCombineMode As CombineRgnStyles) As Boolean
    End Function

    Public Enum CombineRgnStyles As Integer

        RGN_And = 1
        RGN_OR = 2
        RGN_XOR = 3
        RGN_Diff = 4
        RGN_Copy = 5
        RGN_Min = RGN_And
        RGN_Max = RGN_Copy
    End Enum

    <DllImport("gdi32.dll")> _
    Public Shared Function GetPixel( _
        ByVal hDC As IntPtr, _
        ByVal nXPos As Integer, _
        ByVal nYPos As Integer) As Integer
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function GetBkColor( _
        ByVal hDC As IntPtr) As Integer
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function SetPixel( _
        ByVal hDC As IntPtr, _
        ByVal x As Integer, _
        ByVal y As Integer, _
        ByVal crColor As Integer) As Boolean
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function SetPixelV( _
        ByVal hDC As IntPtr, _
        ByVal x As Integer, _
        ByVal y As Integer, _
        ByVal crColor As Integer) As Boolean
    End Function

    <DllImport("gdi32.dll")> _
    Public Shared Function TextOut( _
        ByVal hDC As IntPtr, _
        ByVal nXStart As Integer, _
        ByVal nYStart As Integer, _
        ByVal lpString As String, _
        ByVal lpStringLength As Integer) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function PaintDesktop( _
        ByVal hDC As IntPtr) As Boolean
    End Function

    '********** Socket Programming **********
    <DllImport("ws2_32.dll")> _
    Public Shared Function WSAStartup( _
        ByVal wVersionRequested As Short,
        wsaData As WSAData) As Integer
    End Function

    <StructLayout(LayoutKind.Sequential)>
    Public Structure WSAData
        Const WSADescriptionLength As Integer = 256
        Const WSASystemStatusLength As Integer = 128

        Public Version As Int16
        Public HighVersion As Int16
        <MarshalAs(UnmanagedType.ByValTStr, _
            SizeConst:=WSADescriptionLength + 1)>
        Public Description As String
        <MarshalAs(UnmanagedType.ByValTStr, _
            SizeConst:=WSASystemStatusLength + 1)>
        Public SystemStatus As String
        Public MaxSockets As Int16
        Public MaxUdpDg As Int16
        Public VendorInfo As IntPtr
    End Structure

    <DllImport("ws2_32.dll")> _
    Public Shared Function WSACleanup() As Integer
    End Function

    <DllImport("ws2_32.dll")> _
    Public Shared Function htons( _
        ByVal hostShort As UShort) As UShort
    End Function

    <DllImport("ws2_32.dll")> _
    Public Shared Function htonl( _
        ByVal hostLong As UInteger) As UShort
    End Function

    <DllImport("ws2_32.dll")> _
    Public Shared Function ntohs( _
        ByVal netShort As UShort) As UShort
    End Function

    <DllImport("ws2_32.dll")> _
    Public Shared Function ntohl( _
        ByVal netLong As UInteger) As UInteger
    End Function

    <DllImport("ws2_32.dll", CharSet:=CharSet.Ansi)> _
    Public Shared Function inet_addr( _
        ByVal cp As String) As UInteger
    End Function

    <DllImport("ws2_32.dll", CharSet:=CharSet.Ansi)> _
    Public Shared Function inet_ntoa( _
        ByVal ip As UInteger) As String
    End Function

    <DllImport("ws2_32.dll", CharSet:=CharSet.Ansi)> _
    Public Shared Function socket( _
        ByVal addressFamily As AddressFamilies, _
        ByVal socketType As SocketType, _
        protocolType As ProtocolType) As IntPtr
    End Function

    Public Enum SocketType As Short
        SocketStream = &H1
        SocketDatagram = &H2
        SocketRaw = &H3
        SocketRDM = &H4
        SocketSEQPacketStream = &H5
    End Enum

    Public Enum AddressFamilies As Short

        AF_UNSPEC = &H0
        AF_UNIX = &H1
        AF_INET = &H2
        AF_IMPLINK = &H3
        AF_PUP = &H4
        AF_CHAOS = &H5
        AF_NS = &H6
        AF_IPX = &H6
        AF_ISO = &H7
        AF_OSI = &H7
        AF_ECMA = &H8
        AF_DATAKIT = &H9
        AF_CCITT = &HA
        AF_SNA = &HB
        AF_DECnet = &HC
        AF_DLI = &HD
        AF_LAT = &HE
        AF_HYLINK = &HF
        AF_APPLETALK = &H10
        AF_NETBIOS = &H11
        AF_VOICEVIEW = &H12
        AF_FIREFOX = &H13
        AF_UNKNOWN1 = &H14
        AF_BAN = &H15
        AF_ATM = &H16
        AF_INET6 = &H17
        AF_CLUSTER = &H18
        AF_12844 = &H19
        AF_IRDA = &H1A
        AF_NETDES = &H1C
        AF_TCNPROCESS = &H1D
        AF_TCNMESSAGE = &H1E
        AF_ICLFXBM = &H1F
    End Enum

    Public Enum ProtocolType As Short
        IP = &H0
        ICMP = &H1
        IGMP = &H2
        GGP = &H3
        TCP = &H6
        PUP = &HC
        UDP = &H11
        IDP = &H16
        IPV6 = &H29
        ND = &H4D
        ICLFXBM = &H4E
        Raw = &HFF
        Max = &H100
    End Enum

    <DllImport("ws2_32.dll")> _
    Public Shared Function bind( _
        ByVal socketHandle As IntPtr, _
        ByRef address As SocketAddress, _
        ByVal addressSize As Integer) As Integer
    End Function

    <StructLayout(LayoutKind.Sequential)>
    Public Structure SocketAddress
        Public AddressFamily As AddressFamilies
        Public Port As UShort
        Public IP As Integer
        <MarshalAs(UnmanagedType.ByValArray, SizeConst:=8)>
        Public sin_zero() As Byte
    End Structure

    <DllImport("ws2_32.dll")> _
    Public Shared Function listen( _
        ByVal socketHandle As IntPtr, _
        backlog As Integer) As Integer
    End Function

    <DllImport("ws2_32.dll")> _
    Public Shared Function accept( _
        ByVal socketHandle As IntPtr, _
        ByRef socketAddress As SocketAddress, _
        ByRef socketAddressSize As Integer) As IntPtr
    End Function

    <DllImport("ws2_32.dll")> _
    Public Shared Function connect( _
        ByVal socketHandle As IntPtr, _
        ByRef socketAddress As SocketAddress, _
        ByRef socketAddressSize As Integer) As Boolean
    End Function

    <DllImport("ws2_32.dll")> _
    Public Shared Function send( _
        ByVal socketHandle As IntPtr, _
        ByRef buffer() As Byte, _
        ByRef length As Integer, _
        ByVal flags As MessageFlags) As Integer
    End Function

    <Flags()>
    Public Enum MessageFlags As Integer
        Default1 = &H0
        OutOfBand = &H1
        Peek = &H2
        DoNotRoute = &H4
        WaitAll = &H8
        Partial1 = &H8000
        DoNotWait = &H1000000
    End Enum

    <DllImport("ws2_32.dll")> _
    Public Shared Function recv( _
        ByVal socketHandle As IntPtr, _
        ByRef buffer() As Byte, _
        ByRef length As Integer, _
        ByVal flags As MessageFlags) As Integer
    End Function

    <DllImport("ws2_32.dll")> _
    Public Shared Function closesocket( _
        ByVal socketHandle As IntPtr) As Integer
    End Function

    <DllImport("ws2_32.dll")> _
    Public Shared Function shutdown( _
        ByVal socketHandle As IntPtr, _
        ByRef how As ShutDownFlags) As Integer
    End Function

    Public Enum ShutDownFlags As Integer
        Recive = &H0
        Send = &H1
        Both = &H2
    End Enum

    '*********** Advanced API **************
    <DllImport("user32.dll")> _
    Public Shared Function SendMessage( _
        ByVal hWnd As IntPtr, _
        ByVal Msg As UInt32, _
        ByVal wParam As IntPtr, _
        ByVal lParam As IntPtr) As IntPtr
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function PostMessage( _
        ByVal hWnd As IntPtr, _
        ByVal msg As UInt32, _
        ByVal wParam As IntPtr, _
        ByVal lParam As IntPtr) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function WaitMessage() As Boolean
    End Function

    <DllImport("User32.dll", EntryPoint:="PeekMessageA")> _
    Public Shared Function PeekMessage( _
        ByRef msg As Message,
        ByVal hWnd As IntPtr, _
        ByVal wMessageFilterMin As Integer, _
        ByVal wMessageFilterMax As Integer, _
        ByVal wRemoveMessage As Integer) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function GetMessage( _
        ByRef msg As Message, _
        ByVal hWnd As IntPtr, _
        ByVal wMessageFilterMin As Integer, _
        ByVal wMessageFilterMax As Integer) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function SetWindowsHookEx( _
        ByVal hookType As HookType, _
        ByVal lpFunction As HookProc, _
        ByVal hMod As IntPtr, _
        ByVal dwThreadId As Integer) As IntPtr
    End Function

    <Flags()>
    Public Enum PeekMessageParams As UInteger
        PM_NOREMOVE = &H0
        PM_REMOVE = &H1
        PM_NOYIELD = &H2
    End Enum

    Public Enum HookType As Integer
        WH_JournalRecord = &H0
        WH_JournalPlayback = &H1
        WH_Keyboard = &H2
        WH_GetMessage = &H3
        WH_CallWndProc = &H4
        WH_CBT = &H5
        WH_SysMsgFilter = &H6
        WH_Mouse = &H7
        WH_Hardware = &H8
        WH_Debug = &H9
        WH_Shell = &HA
        WH_ForEGroundIDLE = &HB
        WH_CallWndProcert = &HC
        WH_KeyboardLL = &HD
        WH_MouseLL = &HE
    End Enum

    Public Delegate Function HookProc(
           ByVal code As Integer,
           ByVal wParam As IntPtr,
           ByVal lParam As IntPtr) As IntPtr

    <DllImport("user32.dll")> _
    Public Shared Function UnhookWindowsHookEx( _
        ByVal hookHandle As IntPtr) As Boolean
    End Function

    <DllImport("user32.dll")> _
    Public Shared Function CallNextHookEx( _
        ByVal hookHandle As IntPtr, _
        ByVal nCode As Integer, _
        ByVal wParam As IntPtr, _
        ByVal lParam As IntPtr) As IntPtr
    End Function

    <DllImport("kernel32.dll")> _
    Public Shared Function GetModuleHandle( _
        ByVal lpModuleName As String) As IntPtr
    End Function

    <DllImport("fmifs.dll", EntryPoint:="FormatEx", _
            CharSet:=CharSet.Auto, SetLastError:=True, _
            CallingConvention:=CallingConvention.StdCall)> _
    Public Shared Sub FormatEx( _
        ByVal driveLetter As String, _
        ByVal mediaFlag As Integer, _
        ByVal fsType As String, _
        ByVal label As String, _
        ByVal quickFormat As Boolean, _
        ByVal clusterSize As Integer, _
        ByVal callBackDelegate As FormatCallBackDelegate)
    End Sub

    Public Enum CallbackCommand
        Progress = &H0
        DownWithStructure = &H1
        InSufficientRights = &H6
        DiskLockedForAccess = &H7
        Done = &HB
        Output = &HE
        StructureProgress = &HF
    End Enum

    Public Delegate Function FormatCallBackDelegate( _
        ByVal callBackCommand As CallbackCommand, _
        ByVal subActionCommand As Integer, _
        ByVal action As IntPtr) As Integer

    <DllImport("user32.dll")> _
    Public Shared Function SystemParametersInfo( _
        ByVal uiAction As UInt32, _
        ByVal uiParam As UInt32, _
        ByVal pvParam As UInt32, _
        ByVal fWinIni As UInt32) As Boolean
    End Function
End Class










